#!/bin/bash
# organize_by_type.sh
# Usage: ./organize_by_type.sh /path/to/source /path/to/destination

# Exit immediately if a command fails
set -e

# Ensure two arguments are provided
if [ $# -ne 2 ]; then
    echo "Usage: $0 <source_directory> <destination_directory>"
    exit 1
fi

SRC_DIR="$1"
DEST_DIR="$2"

# Create destination directory if it doesn’t exist
mkdir -p "$DEST_DIR"

# Find all files in source directory recursively
find "$SRC_DIR" -type f | while read -r FILE; do
    # Get the extension (lowercase), or "no_extension" if none
    EXT="${FILE##*.}"
    if [[ "$FILE" == *"."* && "$EXT" != "$FILE" ]]; then
        EXT=$(echo "$EXT" | tr '[:upper:]' '[:lower:]')
    else
        EXT="no_extension"
    fi

    # Create directory for this extension
    TARGET_DIR="$DEST_DIR/$EXT"
    mkdir -p "$TARGET_DIR"

    # Move file into target directory (preserve filename only)
    BASENAME=$(basename "$FILE")
    cp "$FILE" "$TARGET_DIR/$BASENAME"
done

echo "Files organized by type under $DEST_DIR"

